import { formatDistance } from "./cs/_lib/formatDistance.js";
import { formatLong } from "./cs/_lib/formatLong.js";
import { formatRelative } from "./cs/_lib/formatRelative.js";
import { localize } from "./cs/_lib/localize.js";
import { match } from "./cs/_lib/match.js";

/**
 * @category Locales
 * @summary Czech locale.
 * @language Czech
 * @iso-639-2 ces
 * @author David Rus [@davidrus](https://github.com/davidrus)
 * @author Pavel Hrách [@SilenY](https://github.com/SilenY)
 * @author Jozef Bíroš [@JozefBiros](https://github.com/JozefBiros)
 */
export const cs = {
  code: "cs",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
};

// Fallback for modularized imports:
export default cs;
